<?php
/*--------------------------------------------------------------
   GuestCustomersCantBeCreatedWithABalanceException.php 2022-11-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/
declare(strict_types=1);

namespace Gambio\Admin\Modules\Customer\Services\Exceptions;

/**
 * Class GuestCustomersCantBeCreatedWithABalanceException
 *
 * @package Gambio\Admin\Modules\Customer\Services\Exceptions
 */
class GuestCustomersCantBeCreatedWithABalanceException extends CreationOfCustomerFailedException
{
    /**
     * @return GuestCustomersCantBeCreatedWithABalanceException
     */
    public static function create(): GuestCustomersCantBeCreatedWithABalanceException
    {
        return new self('Guest customers can\'t be created with a balance');
    }
}